/*
 * TagTreeProxy.h
 *
 *  Created on: 22.10.2009
 *      Author: stefan.detter
 */

#ifndef TAGTREEPROXY_H_
#define TAGTREEPROXY_H_

#include <QSortFilterProxyModel>

class TagTreeProxy: public QSortFilterProxyModel
{
	Q_OBJECT

public:
	TagTreeProxy(QObject* parent = 0);
	virtual ~TagTreeProxy();

// Source to View
public slots:
	void expandSlot ( const QModelIndex & index );
	void setCurrentIndexSlot ( const QModelIndex & index );
	void setRootIndexSlot ( const QModelIndex & index );
signals:
	void expand ( const QModelIndex & index );
	void setCurrentIndex ( const QModelIndex & index );
	void setRootIndex ( const QModelIndex & index );

// View to Source
public slots:
	void clickedSlot ( const QModelIndex & index );
	void doubleClickedSlot ( const QModelIndex & index );
signals:
	void clicked ( const QModelIndex & index );
	void doubleClicked ( const QModelIndex & index );

protected:
    bool lessThan(const QModelIndex &left, const QModelIndex &right) const;
};

#endif /* TAGTREEPROXY_H_ */
